/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.base;

public class RetryManager {
    public static final long TIMEOUT = 180000L;
    long limit = 180000L;
    long startTime = 0L;
    boolean stop = false;
    Object lastCauseObj = null;
    String lastCauseStr = "OK";
    boolean success = false;

    public static String _get_FILE_DATE() {
        return "$Date:   14 Dec 2006 16:30:24  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   qdang  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.7  $";
    }

    public RetryManager() {
        this.expiredIn(180000L);
    }

    public RetryManager(long limit) {
        this.expiredIn(limit);
    }

    public void expiredIn(long limit) {
        this.limit = limit;
        this.startTime = System.currentTimeMillis();
    }

    public void reset() {
        this.startTime = System.currentTimeMillis();
        this.stop = false;
        this.lastCauseObj = null;
        this.lastCauseStr = "OK";
        this.success = false;
    }

    public boolean getStatus() {
        return this.success;
    }

    public void stop() {
        this.stop = true;
        this.success = true;
    }

    public boolean again() {
        if (!this.stop) {
            boolean bl = this.stop = System.currentTimeMillis() - this.startTime > this.limit;
            if (this.stop) {
                this.lastCauseStr = "Out of time! (" + Long.toString(this.limit) + " ms)";
            }
        }
        return !this.stop;
    }

    public void setCauseObj(Object obj) {
        this.lastCauseStr = obj.toString();
        this.lastCauseObj = obj;
    }

    public Object getCauseObj() {
        return this.lastCauseObj;
    }

    public String toString() {
        if (this.lastCauseObj != null) {
            this.lastCauseStr = this.lastCauseStr + ", " + this.lastCauseObj.toString();
        }
        return this.lastCauseStr;
    }

    public void sleep(int nMilliSeconds) {
        try {
            Thread.sleep(nMilliSeconds);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

